# Dokumentvorlagen

Dokumentvorlagen erlauben es neue Vertragsdokumente auf Basis vordefinierter Dokumente zu erstellen. Ziel ist es, möglichst viele Informationen aus den Metadaten des Vertrags zu übernehmen. Hierzu können in den Vorlagen <span
style='font-weight:bold;font-style:italic'>Platzhalter</span> hinterlegt werden, die beim <a
href="#!/guide/p987E8B3B_D687_486E_A601_F4A3D4ED84EA">Anlegen des Dokuments</a> durch Daten des Vertrags ersetzt werden.

## Dokumentvorlagen bearbeiten

<span class="tag_warning">Dokumentvorlagen müssen dabei Microsoft Word-Dokumente im Format `.doc` oder `.docx` sein, da sonst Platzhalter nicht ersetzt werden können. Sie müssen zudem mit der Verschlagwortungsmaske <span
style='font-weight:bold;font-style:italic'>Vertrag Dokument</span> (<span
style='font-style:italic'>Contract document</span>) abgelegt werden.</span>

### Dokumentvorlagen über die Konfiguration ändern

Vorlagen können direkt über die Konfiguration des Vertragsmanagements unter <span
style='font-weight:bold;font-style:italic'>Dokumentvorlagen</span> bearbeitet werden. Hierbei können neue Vorlagen hinzugefügt, sowie Vorlagen gelöscht und bearbeitet werden.

{@img img1.png}

### Dokumentvorlagen über den Archivbaum ändern

Dokumentvorlagen sind im Ordner `Administration\Business Solutions Custom\contract\Configuration\Document Templates` abgelegt. Eine weitere Untergliederung nach Ordnern ist ebenfalls möglich.

{@img img3.png}

## Individuelle Felder (CUSTOM-Fields)

Zu jeder Dokumentvorlage kann eine Liste individueller Felder hinterlegt werden, die beim Erstellen des Vertrags abgefragt werden. CUSTOM-Felder können anschließend in Word über Platzhalter gesetzt werden.

> <span
style='font-style:italic'>Für den Vertrieb wird ein neuer Rahmenvertrag abgeschlossen. Für diesen Dokumenttyp werden im Word Dokument neben den allgemeinen Vertragsdaten noch der Produktname, die Abnahmemenge sowie die maximale Partnerzahl benötigt. Diese Informationen können über CUSTOM-Felder direkt beim Anlegen des Dokuments abgefragt und automatisch gesetzt werden.</span>

Nachfolgende Abbildung zeigt die Verwendung Individueller Felder beim Anlegen eines neuen Dokuments.

{@img img5.png}

Um ein CUSTOM-Feld zu setzen, muss die Dokumentvorlage ausgewählt werden. Anschließend können im Tab 'Weitere Informationen' CUSTOM-Felder definiert werden. Die Liste wird beim Anlegen neuer Elemente nur angezeigt, wenn mindestens ein Feld mit einem Namen definiert wurde.

{@img img7.png}

## Automatische Datenübernahme durch Platzhalter

Im Template stehen sowohl der selektierte Ordner, als auch das direkte Elternelement zur Verfügung. Des Weiteren kann über den `SOL_TYPE` auf sämtliche Elemente der Elternhierarchie zugegriffen werden.

<span class="tag_caution">Aufgrund technologischer Einschränkungen wird <span
style='font-weight:bold'>empfohlen, MailMerge nicht zu verwenden</span> und stattdessen auf Inhaltssteuerelemente auszuweichen. Diese stellen weitaus mehr Funktionalität wie bspw. Datumskonvertierungen, Counter, Übersetzungsschlüssel, etc. zur Verfügung und<span
style='font-weight:bold'> lassen sich nachträglich aktualisieren</span>.</span>

### Microsoft Word Inhaltssteuerelemente

Für die ELO Business Solution Contract stehen eine Reihe vordefinierter Inhaltssteuerelemente in Form von <span
style='font-weight:bold;font-style:italic'>Schnellbausteinen</span> zur Verfügung. Diese können als Download über das <span
style='font-weight:bold;font-style:italic'>ELO Supportweb</span> bezogen werden.

Im Reiter <span
style='font-weight:bold;font-style:italic'>Einfügen</span> der Multifunktionsleiste von <span
style='font-weight:bold;font-style:italic'>Microsoft Word</span> kann über die Funktion <span
style='font-weight:bold;font-style:italic'>Schnellbausteine</span> anschließend auf die meisten Eigenschaften des Vertrags zugegriffen werden.

{@img img9.png}

<span
style='font-weight:bold'>Importieren der ELO Business Solution Contract - Schnellbausteine</span>

Schnellbausteine werden mithilfe von dotx-Word Vorlagen transportiert. Microsoft Word verwaltet eine Liste aller Bausteine unterhalb des Verzeichnisses <span
style='font-weight:bold;font-style:italic'>Document Building Blocks</span>. Dort befinden sich u.a. ebenfalls die Standard-Bausteine <span
style='font-weight:bold;font-style:italic'>Built-In-Building Blocks.dotx</span>. Der Pfad setzt sich aus dem aktuellen Benutzernamen sowie der Office Version zusammen.

    C:\Users\-USERNAME-\AppData\Roaming\Microsoft\Document Building Blocks\1031\-Office Version-

Nachfolgender Pfad ergibt sich somit für den Benutzernamen <span
style='font-weight:bold;font-style:italic'>MosbachN</span> unter Verwendung von <span
style='font-weight:bold;font-style:italic'>Microsoft Office 2016</span>.

    C:\Users\MosbachN\AppData\Roaming\Microsoft\Document Building Blocks\1031\16\

Für die Installation wird die dotx-Datei in der gewünschten Sprache (EN oder DE) in das obige Verzeichnis abgelegt. Anschließend kann auch bei neuen Dokumenten auf Schnellbausteine des Vertrags zugegriffen werden.

{@img img11.png}

### Microsoft Word Inhaltssteuerelemente manuell erstellen

<span class="tag_important">Um eigene Inhaltssteuerelemente hinzuzufügen, wird das Microsoft Word Ribbon-Tab Entwicklertools benötigt. Dort finden sich ein Rich-Text-Inhaltssteuerelement sowie ein Nur-Text-Inhaltssteuerelement.</span>

Zuerst muss ein neues Inhaltssteuerelement eingefügt werden. Hierzu wird im Reiter <span
style='font-weight:bold;font-style:italic'>Entwicklertools</span> das <span
style='font-weight:bold;font-style:italic'>Nur-Text-Inhaltssteuerelement</span> ausgewählt. Anschließend muss das Inhaltssteuerelement konfiguriert werden. Hierzu muss der Dialog <span
style='font-weight:bold;font-style:italic'>Eigenschaften</span> zum Steuerelement geöffnet werden.

Der <span
style='font-weight:bold;font-style:italic'>Titel</span> des Steuerelementes dient lediglich der Nachvollziehbarkeit und Anzeige. Als <span
style='font-weight:bold'>Tag</span> muss ein gültiger <span style='font-weight:
bold;font-style:italic'>Template-Ausdruck </span>eingegeben werden.

<span class="tag_important"><span
style='font-weight:bold;font-style:italic'>Hinweise zu Templates:</span> Für die Auswertung von Inhaltssteuerelementen wird auf Template-Ausdrücke zurückgegriffen. Dies erlaubt es komfortabel Datumsoperationen, Bedingungen, etc. in Word einzusetzen. Eine Liste der Möglichkeiten gibt die Klassendokumentation `sol.common.Template`.</span>

{@img img13.png}

<span
style='font-weight:bold'>Definition eines Template-Ausdrucks:</span>

Für die Auswertung von Template-Ausdrücken wird auf die freie Bibliothek handlebars.js zurückgegriffen. Zugriff auf Informationen erfolgt daher immer durch `{{ .. }}` oder `{{{ … }}}`. 

<span class="tag_warning">Bei einem Zugriff auf Informationen sollte immer die 3-fach Notation `{{{` verwendet werden, da hier die Daten nicht escaped werden.</span>

Um alle benötigten Informationen für die Dokumenterstellung bereitzustellen, wird die gesamte Hierarchie eines Dokuments abgeholt. Dazu gehört der zugehörige <span
style='font-weight:bold;font-style:italic'>Vertrag</span> (`CONTRACT`), die <span
style='font-weight:bold;font-style:italic'>Vertragsstruktur</span> (`CONTRACT_STRUCTURE`) sowie das <span
style='font-weight:bold;font-style:italic'>Vertragsdokument</span> (`CONTRACT_DOCUMENT`). Informationen werden dabei in ELO als <span
style='font-weight:bold;font-style:italic'>Indexfelder</span> (`objKeys`) oder <span
style='font-weight:bold;font-style:italic'>Map-Felder</span> (`mapKeys`) gespeichert. 

    {
      CONTRACT: {
        name: 'Short description',
        objKeys: {
          // Index-Felder
          CONTACT_LAST_NAME: 'Smith',
        },
        mapKeys: {
          // Map-Felder
          COST_CENTER_NAME: 'Accounting',
        }
      },
      CONTRACT_STRUCTURE: {
        name: 'Short description',
        objKeys: {    },
        mapKeys: {    }
      },
      CONTRACT_DOCUMENT: {
        name: 'Short description',
        objKeys: {    },
        mapKeys: {  
          CUSTOM1: '',
          CUSTOM2: ''
        }
      }
    }

Einige Beispiele für den Zugriff auf Informationen:

*   Nachname des Vertragspartners: `{{{ CONTRACT.objKeys.CONTACT_LAST_NAME }}}`
*   Name der Kostenstelle des Vertrags: `{{{ CONTRACT.mapKeys.COST_CENTER_NAME }}}`
*   Custom Feld ausgeben: `{{{ CONTRACT_DOCUMENT.mapKeys.CUSTOM1 }}}`
*   Kurzbezeichnung des Vertrags: `{{{ CONTRACT.name }}}`
*   Datumsformatierung: `{{ formatDate 'DD.MM.YYYY' CONTRACT.objKeys.CONTRACT_START }}`

### Microsoft Word MailMerge

Neben den Inhaltssteuerelementen besteht auch die Möglichkeit, eine Datenübergabe mithilfe der MailMerge-Funktionalität von Microsoft Word abzubilden.

MailMerge Felder können über die Funktion <span
style='font-weight:bold;font-style:italic'>Schnellbausteine &gt; Feld einfügen</span> (Microsoft Word 2016) erstellt werden. Als Feldtyp muss anschließend MergeField gewählt werden. 

{@img img15.png}

<span class="tag_warning">Damit auf Informationen zugegriffen werden kann, müssen alle Felder mit einem MergeField «TableStart:hierarchy» sowie «TableEnd:hierarchy» umgeben werden.</span>

Anschließend kann zwischen TableStart und TableEnd auf Informationen der Verträge zugegriffen werden. 

{@img img17.png}

Verglichen mit den Inhaltssteuerelementen wird eine weitere Ebene <span
style='font-weight:bold;font-style:italic'>hierarchy</span> eingeführt. Diese ist notwendig, da MailMerge einen Startknoten benötigt. Der Startknoten wird durch ein extra MergeField <span
style='font-weight:bold;font-style:italic'>TableStart</span> gewählt.

    {
      hierarchy: {
        CONTRACT: {
        },
        CONTRACT_STRUCTURE: {
        },
        CONTRACT_DOCUMENT: {
        }
      }
    }

Einige Beispiele für<span
style='font-weight:bold;font-style:italic'> MergeField Feldnamen</span> für den Zugriff auf Informationen:

*   Nachname des Vertragspartners: `CONTRACT.objKeys.CONTACT_LAST_NAME`
*   Name der Kostenstelle des Vertrags: `CONTRACT.mapKeys.COST_CENTER_NAME`
*   Custom Feld ausgeben: `CONTRACT_DOCUMENT.mapKeys.CUSTOM1`
*   Kurzbezeichnung des Vertrags: `CONTRACT.name`


